# **Week 04 - Offline Videos**

## Assignment #1 - Your logic is like a doctor

**Learn by doing, lets create an in memory hospital**

**You need to create 4 routes (4 things that the hospital can do)**

1. GET - User can check how many kidneys they have and their health
2. POST - User can add a new kidney
3. PUT - User can replace a kidney, make it healthy
4. DELETE - User can remove a kidney

-   What should happen if they try to delete when there are no kidneys?
-   What should happen if they try to make a kidney healthy when all are already healthy?

**Solution** - [https://gist.github.com/hkirat/7b78356bd28022aecd476d29f3e6645f](https://gist.github.com/hkirat/7b78356bd28022aecd476d29f3e6645f)

## Assignment #2 - You need to create an express HTTP server in Node.js which will handle the logic of a file server.

-  Use built in Node.js `fs` module

   The expected API endpoints are defined below,

1. GET `/files` - Returns a list of files present in `./files/` directory

   Response: 200 OK with an array of file names in JSON format.

   Example: GET http://localhost:3000/files

2. GET `/file/:filename` - Returns content of given file by name
   Description: Use the filename from the request path parameter to read the file from `./files/` directory

    Response: 200 OK with the file content as the response body if found, or 404 Not Found if not found. Should return `File not found` as text if file is not found

    Example: GET http://localhost:3000/file/example.txt

-   For any other route not defined in the server return 404

## Assignment #3 & #4 - You need to create an express HTTP server in Node.js which will handle the logic of a todo list app.

- **`Assignment #3`** - Don't use any database, just store all the data in an array to store the todo list data (in-memory)
- **`Assignment #4`** -  Hard todo: Try to save responses in files, so that even if u exit the app and run it again, the data remains (similar to databases)

   Each todo has a title and a description. The title is a string and the description is a string.

   Each todo should also get an unique autogenerated id every time it is created

   The expected API endpoints are defined below,
1. GET `/todos` - Retrieve all todo items

   Description: Returns a list of all todo items.

   Response: 200 OK with an array of todo items in JSON format.

   Example: GET http://localhost:3000/todos

2. GET `/todos/:id` - Retrieve a specific todo item by ID

   Description: Returns a specific todo item identified by its ID.

   Response: 200 OK with the todo item in JSON format if found, or 404 Not Found if not found.

   Example: GET http://localhost:3000/todos/123

3. POST `/todos` - Create a new todo item

   Description: Creates a new todo item.

   Request Body: JSON object representing the todo item.

   Response: 201 Created with the ID of the created todo item in JSON format. eg: {id: 1}

   Example: POST http://localhost:3000/todos

   Request Body: { "title": "Buy groceries", "completed": false, description: "I should buy groceries" }

4. PUT `/todos/:id` - Update an existing todo item by ID

   Description: Updates an existing todo item identified by its ID.

   Request Body: JSON object representing the updated todo item.

   Response: 200 OK if the todo item was found and updated, or 404 Not Found if not found.

   Example: PUT http://localhost:3000/todos/123

   Request Body: { "title": "Buy groceries", "completed": true }

5. DELETE `/todos/:id` - Delete a todo item by ID

   Description: Deletes a todo item identified by its ID.

   Response: 200 OK if the todo item was found and deleted, or 404 Not Found if not found.
   
   Example: DELETE http://localhost:3000/todos/123
   
   - For any other route not defined in the server return 404

## Assignment #5 - You have to create a middleware for logging the number of requests on a server
```
You have been given an express server which has a few endpoints.

Your task is to create a global middleware (app.use) which will maintain a count of the number of 
requests made to the server in the global requestCount variable
```

## Assignment #6 - You have to create a middleware for rate limiting a users request based on their username passed in the header
```
You have been given an express server which has a few endpoints.

Your task is to create a global middleware (app.use) which will rate limit the requests from a user to only 5 request per second
- If a user sends more than 5 requests in a single second, the server should block them with a 404.
- User will be sending in their user id in the header as 'user-id'
- You have been given a numberOfRequestsForUser object to start off with which clears every one second
```


## Assignment #7 - You have to create a middleware for logging the number of errors on a server
```
You have been given an express server which has a few endpoints.

Your task is to
1. Ensure that if there is ever an exception, the end user sees a status code of 404
2. Maintain the errorCount variable whose value should go up every time there is an exception in any endpoint
```